//@input Component.ScreenTransform child
//@input SceneObject touchZoneSceneObject
//@input Component.ScreenTransform segmentsHeaderScreenTransform
//@input Component.ScreenTransform texturePreviewScreenTransform
//@input Component.ScreenTransform texturePreviewParentScreenTransform
//@input Component.ScreenTransform headerMaskTopScreenTransform
//@input Component.ScreenTransform closingZoneScreenTransform
//@input Component.ScreenTransform topBorderScreenTransform
//@input SceneObject roundedCornersScObject
//@input SceneObject headerWithRank
//@input SceneObject headerWithRankSimple
//@input SceneObject headerWithRankFull
//@input Component.Text percentileRankText
//@input Component.Text globalExactRankText
//@input Component.Text scoresSharedText
//@input Component.Text timeText
//@input Component.Text resetsText
//@input Component.Image bitmojiHeaderImage
//@input Component.Image customTextureImage
//@input Asset.Material timerMaterial
//@input Component.Text leaderboardName
//@input SceneObject[] postEffects
//@input Component.ScreenTransform outOfLeaderboardTouchZone
//@input Component.Text headerScoresMiddleText
//@input SceneObject[] backgroundCustomizationsNone
//@input SceneObject[] backgroundCustomizationsBitmoji
//@input SceneObject[] backgroundCustomizationsTexture
//@input SceneObject[] timerSceneObjects

script.getEntriesParentScreenTransform = getEntriesParentScreenTransform;
script.getTexturePreviewScreenTransform = getTexturePreviewScreenTransform;
script.getTexturePreviewParentScreenTransform = getTexturePreviewParentScreenTransform;
script.getTopBorderScreenTransform = getTopBorderScreenTransform;
script.getRoundedCornersTransform = getRoundedCornersTransform;
script.getTouchZoneSceneObject = getTouchZoneSceneObject;
script.setHeaderAnchors = setHeaderAnchors;
script.setHeaderMaskTopAnchors = setHeaderMaskTopAnchors;
script.getClosingZoneScreenTransform = getClosingZoneScreenTransform;
script.setCurrentUserRecord = setCurrentUserRecord;
script.setHeaderEnabled = setHeaderEnabled;
script.setFixedSizedTextureHeader = setFixedSizedTextureHeader;
script.setPostEffectsEnabled = setPostEffectsEnabled;
script.setLeaderboardName = setLeaderboardName;
script.getOutOfLeaderboardTouchZone = getOutOfLeaderboardTouchZone;
script.setResisableTextureHeader = setResisableTextureHeader;
script.setBackgroundCustomizationOptionEnabled = setBackgroundCustomizationOptionEnabled;
script.getCustomTextureImage = getCustomTextureImage;
script.setTimeLeftText = setTimeLeftText;
script.setResetText = setResetText;
script.setTimerUiEnabled = setTimerUiEnabled;
script.setTimerTexture = setTimerTexture;

let BackgroundCustomization;
(function(BackgroundCustomization) {
    BackgroundCustomization[BackgroundCustomization["None"] = 0] = "None";
    BackgroundCustomization[BackgroundCustomization["Bitmoji"] = 1] = "Bitmoji";
    BackgroundCustomization[BackgroundCustomization["Texture"] = 2] = "Texture";
})(BackgroundCustomization || (BackgroundCustomization = {}));

function getOutOfLeaderboardTouchZone() {
    return script.outOfLeaderboardTouchZone;
}

function getEntriesParentScreenTransform() {
    return script.child;
}

function getTopBorderScreenTransform() {
    return script.topBorderScreenTransform;
}

function getRoundedCornersTransform() {
    return script.roundedCornersScObject.getTransform();
}

function getTexturePreviewScreenTransform() {
    return script.texturePreviewScreenTransform;
}

function getTexturePreviewParentScreenTransform() {
    return script.texturePreviewParentScreenTransform;
}

function getTouchZoneSceneObject() {
    return script.touchZoneSceneObject;
}

function setHeaderAnchors(anchors) {
    script.segmentsHeaderScreenTransform.anchors = anchors;
}

function setHeaderMaskTopAnchors(anchors) {
    script.headerMaskTopScreenTransform.anchors = anchors;
}

function setHeaderEnabled(enabled) {
    script.headerWithRank.enabled = enabled;
}

function getCustomTextureImage() {
    return script.customTextureImage;
}

function getClosingZoneScreenTransform() {
    return script.closingZoneScreenTransform;
}

function setCurrentUserRecord(userRecord) {
    const isGlobalRankPercentileAvailable = !isNull(userRecord.globalRankPercentile) && userRecord.globalRankPercentile !== undefined && userRecord.globalRankPercentile !== 0;
    const isGlobalExactRankAvailable = !isNull(userRecord.globalExactRank) && userRecord.globalExactRank !== undefined && userRecord.globalExactRank !== 0;

    if (isGlobalRankPercentileAvailable) {
        script.percentileRankText.text = "Top " + userRecord.globalRankPercentile + "%";
    }

    if (isGlobalExactRankAvailable) {
        script.globalExactRankText.text = userRecord.globalExactRank + "";
    }

    if (isGlobalExactRankAvailable && isGlobalRankPercentileAvailable) {
        script.headerWithRankSimple.enabled = false;
        script.headerWithRankFull.enabled = true;
    } else if (isGlobalRankPercentileAvailable) {
        script.headerWithRankSimple.enabled = true;
        script.headerWithRankFull.enabled = false;
        script.headerScoresMiddleText.text = "You Are In The";
        script.scoresSharedText.text = "Top " + userRecord.globalRankPercentile + "%";
    } else if (isGlobalExactRankAvailable) {
        script.headerWithRankSimple.enabled = true;
        script.headerWithRankFull.enabled = false;
        script.headerScoresMiddleText.text = "Global Rank";
        script.scoresSharedText.text = userRecord.globalExactRank + "";
    }
}

function setFixedSizedTextureHeader(bitmoji) {
    script.bitmojiHeaderImage.getSceneObject().enabled = true;
    script.bitmojiHeaderImage.mainPass.baseTex = bitmoji;
}

function setResisableTextureHeader(customTexture) {
    script.customTextureImage.getSceneObject().enabled = true;
    script.customTextureImage.mainPass.baseTex = customTexture;
    script.customTextureImage.mainPass.baseColor = vec4.zero();

    const oneFrameDelay = script.createEvent("DelayedCallbackEvent");
    oneFrameDelay.bind(() => {
        script.customTextureImage.mainPass.baseColor = vec4.one();
        script.removeEvent(oneFrameDelay);
    });
    oneFrameDelay.reset(0.0000001);
}

function setPostEffectsEnabled(enabled) {
    script.postEffects.forEach((so) => so.enabled = enabled);
}

function setLeaderboardName(leaderboardName) {
    script.leaderboardName.text = leaderboardName;
}

function setBackgroundCustomizationOptionEnabled(backgroundCustomizationOption) {
    switch (backgroundCustomizationOption) {
        case BackgroundCustomization.None:
            break;
        case BackgroundCustomization.Bitmoji:
            script.backgroundCustomizationsBitmoji.forEach((so) => so.enabled = true);
            break;
        case BackgroundCustomization.Texture:
            script.backgroundCustomizationsTexture.forEach((so) => so.enabled = true);
            break;
        default:
            break;
    }
}

function setTimeLeftText(text) {
    script.timeText.text = text;
}

function setResetText(text) {
    script.resetsText.text = text;
}

function setTimerTexture(timerTextureType) {
    script.timerMaterial.mainPass.textureSwitcher = timerTextureType;
}

function setTimerUiEnabled(enabled) {
    script.timerSceneObjects.forEach((scObj) => {
        scObj.enbaled = enabled;
    });
}
